package w83b.w83bOperacionesPaso.w83bResultados;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesPdf;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaDelegConvDetCentroPdfAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {


		Comparator comparador=Collections.reverseOrder();
        
        Map general = (HashMap)contexto.get("w83bMapResultadosBean");
        Map convenios=(HashMap)general.get("convenios");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        
        Font fonttitulo = FontFactory.getFont("Arial", 12, Font.BOLD);
        Font fontbold = FontFactory.getFont("Arial", 8, Font.BOLD);
		Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 8, Font.NORMAL);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()); 
      
		Document document = new Document();			

		document = new Document(PageSize.A4.rotate()); //Creo un documento 		
		document.setMargins(30, 30, 80, 40);	
	    
		PdfWriter.getInstance(document, response.getOutputStream());		
		response.setContentType("application/pdf");		
    	response.setHeader("Content-Disposition", "attachment;filename=w83bDelegadosPorConvenioDetalle.pdf;");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        response.setStatus(HttpServletResponse.SC_OK);
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance(document, baos);	
        
        //Evento para cabecera de pgina
		Rectangle rct = new Rectangle(54, 36, 788 , 589);
        writer.setBoxSize("art", rct);
        
        W83bUtilidadesPdf.HeaderFooter event = new W83bUtilidadesPdf.HeaderFooter(idioma, usuario.getCalleListadosFormateada());
        writer.setPageEvent(event);
        
        document.open();      
              
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        Paragraph parrafo;
        PdfPCell cell;
        
        parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.delegConvenioHist",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.delegConvenioHist",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fonttitulo);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);
        	parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        	document.add(parrafo);
        }
        parrafo=new Paragraph(" ");
        document.add(parrafo);
        
        PdfPTable table=new PdfPTable(6);
        table.setWidthPercentage(100);
        
        float[] columnWidths = {0.15f, 1.40f, 1.60f, 0.15f, 1.40f, 1.60f};

        table.setWidths(columnWidths);
        
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        cell.setBorder(0);
        table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getDescTerritorio(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	 if(StringUtils.isNotEmpty(resultadoBean.getSectorTxt())){
    		 cell = new PdfPCell(new Phrase(resultadoBean.getSectorTxt(),fontnormalpeq));
         }   
    	 else{
    		 cell = new PdfPCell(new Phrase(""));
    	 }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.convenio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegados.convenio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getConvenioTxt())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getConvenioTxt(),fontnormalpeq));
        }
    	else{
    		cell = new PdfPCell(new Phrase(""));
    	}
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	document.add(table);
    	
    	table=new PdfPTable(6);
        table.setWidthPercentage(100);

        table.setWidths(columnWidths);
        cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionDesde(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionHasta",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionHasta",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionHasta(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fregdefhasta",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fregdefhasta",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaRegistroDefinitivo(),fontnormalpeq));
        }
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
        cell.setBorder(0);
        table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.detallecentro",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.detallecentro",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	
    	document.add(table);
    	
    	parrafo=new Paragraph(" ");
    	document.add(parrafo);     
        
        table=new PdfPTable(10);
        table.setWidthPercentage(100);
        
        int contador=0;
        int contadorconvenio=0;
        
        Map mapConveniosOrdenado = new TreeMap(convenios);
        Set ref = mapConveniosOrdenado.keySet();
        
        String[]valores;
        String convenio;
        String centro;
        String acta;
        
        int electores=0;
        int numvotos=0;
        
        //Totales convenio
        int totalelectores;
        int totalvotos;
        int totaldelegados;
        List sindicatossector=new ArrayList();
        
        //Totales territorio
        int totalelectoresterrit=0;
        int numvotosterrit=0;
        int totaldelegadosterrit=0;
        List sindicatossectorterrit=new ArrayList();
        boolean poneriniciofila=false;
        boolean nootros=false;
	   for( Iterator it = ref.iterator(); it.hasNext();) {
		    contador=0;
		    contadorconvenio=0;
	        totalelectores=0;
	        totalvotos=0;
	        numvotos=0;
	        totaldelegados=0;
	        totalelectores=0;
	        sindicatossector=new ArrayList();//NOPMD
		    convenio=(String)it.next();
        	valores=convenio.split("\\|");
        	//Descripcin convenio
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.convenio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.convenio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+Integer.parseInt(valores[0])+"-"+valores[1],fontbold);//NOPMD
        	document.add(parrafo);
            
            table=new PdfPTable(10);//NOPMD
            float[] columnTabla = {7f, 2f, 1f, 1f, 1f, 1f, 1f, 1.5f, 1f, 1f};
            table.setWidths(columnTabla);
            table.setWidthPercentage(100);
        	
          	//Fila central sindical...
            contador=contador+1;
        	cell = new PdfPCell(new Phrase(""));//NOPMD
        	cell.setBorder(0);
        	cell.setColspan(6);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralsindical",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralsindical",W83bClsConstantes.CONSTANTE_CASTELLANO),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setColspan(2);
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.Delegados",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.Delegados",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	cell.setColspan(2);
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
           
        	//Fila denominacin convenio...
        	contador=contador+1;
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.nombrecentro",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.nombrecentro",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD     	
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	cell.setBackgroundColor(new Color(204,204,204));  //NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.elect",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.elect",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.votant",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.votant",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.deleg",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.deleg",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.partic",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.partic",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.sindicatos.siglas",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.sindicatos.siglas",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	table.addCell(cell);
        	cell = new PdfPCell(new Phrase("%",fontbold));//NOPMD
        	cell.setBackgroundColor(new Color(204,204,204));//NOPMD
        	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        	cell.setBorder(Rectangle.NO_BORDER);
        	cell.setBorder(Rectangle.TOP);
        	table.addCell(cell);        	
            int numdelegados;
            //Descripcin convenio
            Map mapActasOrdenado = new TreeMap((Map)mapConveniosOrdenado.get(convenio));//NOPMD
            Set refc = mapActasOrdenado.keySet();
        	for(Iterator itconv = refc.iterator(); itconv.hasNext();) {
        		contador=contador+1;
        		contadorconvenio=contador;
        		centro=(String)itconv.next();
        		numdelegados=0;
            	valores=centro.split("\\|");
            	if(StringUtils.isNotEmpty(valores[1])){
            		cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
            		cell.setBorder(0);
             		if (contador==3){
            			cell.setBorder(Rectangle.TOP);
            		}
            	}
            	table.addCell(cell);
            	numdelegados=0;
            	acta=(String)valores[0];
            	String actater="";
            	if (acta.startsWith("1")){
            		actater="0"+acta;
            	}
            	else{
            		actater=acta;
            	}
            	StringBuffer sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
            	String valor=W83bUtilidadesComunes.rellenarCeros(actater.substring(6,12));
            	sb.append(valor);
            	cell = new PdfPCell(new Phrase(Integer.parseInt(actater.substring(0,2))+"/"+actater.substring(2,6)+"/"+sb.toString(),fontnormal));//NOPMD
        		cell.setBorder(0);
        		cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
        		table.addCell(cell);
                String datos=(String)((List)mapActasOrdenado.get(centro)).get(((List)mapActasOrdenado.get(centro)).size()-1);
                valores=datos.split("\\|");
                if(StringUtils.isNotEmpty(valores[0])){
                	cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
            		cell.setBorder(0);
            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                }
                table.addCell(cell);
                if(StringUtils.isNotEmpty(valores[1])){
                	cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(Integer.parseInt(valores[1])),fontnormal));//NOPMD
            		cell.setBorder(0);
            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                }
                table.addCell(cell);
                electores=Integer.parseInt(valores[0]);
                totalelectores=totalelectores+electores;
                totalelectoresterrit=totalelectoresterrit+electores;
                numvotos=Integer.parseInt(valores[1]);
                totalvotos=totalvotos+numvotos;
                numvotosterrit=numvotosterrit+numvotos;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	numdelegados=numdelegados+Integer.parseInt(valores[0]);//
                }
                boolean otros=false;
                poneriniciofila=false;
                int delegados=0;
                for (int i=0;i<((List)mapActasOrdenado.get(centro)).size()-1;i++){
                	if (i!=0&&poneriniciofila){
            			cell = new PdfPCell(new Phrase(""));//NOPMD
            			cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		table.addCell(cell);
                		contador=contador+1;
            		}
                	sindicatossector=W83bUtilidadesComunes.listaSindicatos(sindicatossector, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	sindicatossectorterrit=W83bUtilidadesComunes.listaSindicatos(sindicatossectorterrit, (String)((List)mapActasOrdenado.get(centro)).get(i));
                	valores=((String)((List)mapActasOrdenado.get(centro)).get(i)).split("\\|");
                	//debemos mirar  si el % no supera el que hemos puesto, para ponerlo en otros
                	if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados)*100<porcentajeFiltro.floatValue()){//
                		delegados=delegados+Integer.parseInt(valores[0]);//
                		otros=true;
                		poneriniciofila=false;
                	}
                	else{
                		poneriniciofila=true;
                		cell = new PdfPCell(new Phrase(""));//NOPMD
            			cell.setBorder(0);
            			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                		table.addCell(cell);
                		cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                		table.addCell(cell);
                		if ("-1".equals(valores[2])){
                			cell = new PdfPCell(new Phrase(""));//NOPMD
	            			cell.setBorder(0);
	            			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[2])){
	                			cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.numero(valores[2])),fontnormal));//NOPMD
		            			cell.setBorder(0);
		            			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
	                		}
	                	}
                		table.addCell(cell);
                		if ("-1".equals(valores[2])){//
                			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
            				cell.setBorder(0);
	                	}else if ("null".equals(valores[1])){
	                		cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	            			cell.setBorder(0);
	                	}
	                	else{
	                		if(StringUtils.isNotEmpty(valores[1])){
	                			cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
		            			cell.setBorder(0);
	                		}
	                	}	
                		table.addCell(cell);
	                    if(StringUtils.isNotEmpty(valores[0])){
	                    	cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
            				cell.setBorder(0);
            				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	                    }
	                    table.addCell(cell);
	                    totaldelegados=totaldelegados+Integer.parseInt(valores[0]);//
	                    totaldelegadosterrit=totaldelegadosterrit+Integer.parseInt(valores[0]);//
	                    cell = new PdfPCell(new Phrase(W83bUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),numdelegados),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				if (contador==3){
                			cell.setBorder(Rectangle.TOP);
                		}
        				table.addCell(cell);
                		}
                	}
                    if(otros){
                    	if (poneriniciofila){
                    		contador=contador+1;
                    		cell = new PdfPCell(new Phrase(""));//NOPMD
                    		cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                        	cell = new PdfPCell(new Phrase(""));//NOPMD
                        	cell.setBorder(0);
                        	table.addCell(cell);
                    	}
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                		cell.setBorder(0);
                		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                    	table.addCell(cell);
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                    	cell.setBorder(0);
                    	cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
                    	table.addCell(cell);
                    	cell = new PdfPCell(new Phrase(""));//NOPMD
                    	cell.setBorder(0);
                    	table.addCell(cell);
                		totaldelegados=totaldelegados+delegados;
                		totaldelegadosterrit=totaldelegadosterrit+delegados;
                		//metemos la linea de otros
                		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));//NOPMD
        				cell.setBorder(0);
        				table.addCell(cell);
        				
        				cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(delegados),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				table.addCell(cell);
        				
        				cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.calcularporcentajePdf(delegados,numdelegados)),fontnormal));//NOPMD
        				cell.setBorder(0);
        				cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        				if (contador==3){
                			cell.setBorder(Rectangle.TOP);
                		}
        				table.addCell(cell);             		
                	}
                    PdfPCell[] cells=(PdfPCell[])table.getRow(contadorconvenio-1).getCells();
                	cells[4].setPhrase(new Phrase(String.valueOf(numdelegados),fontnormal));//NOPMD
                	cells[5].setPhrase(new Phrase(W83bUtilidades.calcularporcentajePdf(numvotos,electores),fontnormal)); 	//NOPMD
        	}
        	poneriniciofila=false;
        	nootros=false;
     	    cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalconvenio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalconvenio",W83bClsConstantes.CONSTANTE_CASTELLANO),fontnormal));//NOPMD
  		    cell.setBorder(0);
  		    cell.setBorder(Rectangle.TOP);
  		    table.addCell(cell);
  		    cell = new PdfPCell(new Phrase(""));//NOPMD
		    cell.setBorder(0);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(totalelectores),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(totalvotos),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(totaldelegados),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
		    cell = new PdfPCell(new Phrase(W83bUtilidades.calcularporcentajePdf(totalvotos,totalelectores),fontnormal));//NOPMD
		    cell.setBorder(0);
		    cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    cell.setBorder(Rectangle.TOP);
		    table.addCell(cell);
        	boolean otros=false;
        	int delegados=0;
        	Collections.sort(sindicatossector,comparador);//la ordenamos de mayor a menor
        	for (int i=0;i<sindicatossector.size();i++){
        		if (i!=0&&poneriniciofila){
        			cell = new PdfPCell(new Phrase(""));//NOPMD
        			cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
        		}
        		valores=((String)sindicatossector.get(i)).split("\\|");
        		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegados)*100<porcentajeFiltro.floatValue()){//
        			delegados=delegados+Integer.parseInt(valores[0]);//
        			otros=true;
        			poneriniciofila=false;
        		}
        		else{
        			poneriniciofila=true;
        			nootros=true;
	        		if ("-1".equals(valores[2])){//
	        			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	        			cell.setBorder(0);
	        			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[2])){
	        				cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.numero(valores[2])),fontnormal));//NOPMD
		        			cell.setBorder(0);
		        			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
		        			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
	        			}
	        		}
	        		table.addCell(cell);
	            	if ("-1".equals(valores[2])){//
	            		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
	            		cell.setBorder(0);
	            		if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        		}else if ("null".equals(valores[1])){
	        			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
	        			cell.setBorder(0);
	        			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[1])){
	        				cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
		        			cell.setBorder(0);
		        			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
	        			}
	        		}
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(valores[0])){
	            		cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
	            		cell.setBorder(0);
	            		if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
	            		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	            	}
	            	table.addCell(cell);
	            	cell = new PdfPCell(new Phrase(W83bUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),totaldelegados),fontnormal));//NOPMD
	            	cell.setBorder(0);
	            	if (i==0){
        				cell.setBorder(Rectangle.TOP);
        			}
	            	cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	            	table.addCell(cell);
        		}
        	}
        	if(otros){
        		if (poneriniciofila){
        			cell = new PdfPCell(new Phrase(""));//NOPMD
        			cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
            		cell = new PdfPCell(new Phrase(""));//NOPMD
            		cell.setBorder(0);
            		table.addCell(cell);
        		}
        		//metemos la linea de otros
        		cell = new PdfPCell(new Phrase(""));//NOPMD
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));//NOPMD
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(delegados),fontnormal));//NOPMD
        		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);
        		cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.calcularporcentajePdf(delegados,totaldelegados)),fontnormal));//NOPMD
        		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
        		cell.setBorder(0);
        		if (!nootros){
            		cell.setBorder(Rectangle.TOP);
            	}
        		table.addCell(cell);		
        	}
        	if (contadorconvenio!=mapConveniosOrdenado.size()){ 
        		document.add(table);
                document.newPage();
        	}
        }
	   poneriniciofila=false;
	   nootros=false;
	   if (!"".equals(resultadoBean.getDescTerritorio())){
			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_CASTELLANO),fontnormal));
		}
		else{
			cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_CASTELLANO),fontnormal));
		}
	   cell.setBorder(0);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(""));
	   cell.setBorder(0);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(totalelectoresterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(numvotosterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(totaldelegadosterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
	   cell = new PdfPCell(new Phrase(W83bUtilidades.calcularporcentajePdf(numvotosterrit,totalelectoresterrit),fontnormal));
	   cell.setBorder(0);
	   cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
	   cell.setBorder(Rectangle.TOP);
	   table.addCell(cell);
       boolean otros=false;
	 	int delegados=0;
	 	Collections.sort(sindicatossectorterrit,comparador);//la ordenamos de mayor a menor
	 	for (int i=0;i<sindicatossectorterrit.size();i++){
		 		if (i!=0&&poneriniciofila){
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);			 		  
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		   cell = new PdfPCell(new Phrase(""));//NOPMD
			 		   cell.setBorder(0);
			 		   table.addCell(cell);
			 		}
		    		valores=((String)sindicatossectorterrit.get(i)).split("\\|");
		    		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit)*100<porcentajeFiltro.floatValue()){//
		    			delegados=delegados+Integer.parseInt(valores[0]);//
		    			otros=true;
		    			poneriniciofila=false;
		    		}
		    		else{
		    			poneriniciofila=true;
		    			nootros=true;
			    		if ("-1".equals(valores[2])){//
			    			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			    		}
			    		else{
			    			if(StringUtils.isNotEmpty(valores[2])){
			    				cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.numero(valores[2])),fontnormal));//NOPMD
				    			cell.setBorder(0);
				    			cell.setHorizontalAlignment(Element.ALIGN_CENTER);
				    			if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    			}
			    		}
			    		table.addCell(cell);
			        	if ("-1".equals(valores[2])){
			        		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase(),fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			    		}else if ("null".equals(valores[1])){
			    			cell = new PdfPCell(new Phrase("",fontnormal));//NOPMD
			    			   cell.setBorder(0);
			    			   if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    		}
			    		else{
			    			if(StringUtils.isNotEmpty(valores[1])){
			    				cell = new PdfPCell(new Phrase(valores[1],fontnormal));//NOPMD
				    			cell.setBorder(0);
				    			if (i==0){
			        				cell.setBorder(Rectangle.TOP);
			        			}
			    			}
			    		}
			        	table.addCell(cell);
			        	if(StringUtils.isNotEmpty(valores[0])){
			        		cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(Integer.parseInt(valores[0])),fontnormal));//NOPMD
			    			cell.setBorder(0);
			    			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
			    			if (i==0){
		        				cell.setBorder(Rectangle.TOP);
		        			}
			        	}
			        	table.addCell(cell);
			        	cell = new PdfPCell(new Phrase(W83bUtilidades.calcularporcentajePdf(Integer.parseInt(valores[0]),totaldelegadosterrit),fontnormal));//NOPMD
		    			cell.setBorder(0);
		    			cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
		    			if (i==0){
	        				cell.setBorder(Rectangle.TOP);
	        			}
		    			table.addCell(cell);
		    		}

    	}
	 	if(otros){
	 		if (poneriniciofila){
	 			cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);			 		  
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
		 		   cell = new PdfPCell(new Phrase(""));
		 		   cell.setBorder(0);
		 		   table.addCell(cell);
	 		}
	 		//metemos la linea de otros
    		cell = new PdfPCell(new Phrase(""));
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase(),fontnormal));
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(W83bUtilidades.separadorMiles(delegados),fontnormal));
    		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);
    		cell = new PdfPCell(new Phrase(String.valueOf(W83bUtilidades.calcularporcentajePdf(delegados,totaldelegadosterrit)),fontnormal));
    		cell.setHorizontalAlignment(Element.ALIGN_RIGHT);
    		cell.setBorder(0);
    		if (!nootros){
        		cell.setBorder(Rectangle.TOP);
        	}
    		table.addCell(cell);		
    	}
	 	
	    document.add(table);
		document.close();
		
		W83bUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"horizontal");
		
		OutputStream out = response.getOutputStream();	        
        baos.writeTo(out);
        out.flush();			
	    out.close();
		
   	return null;
	}
	
}
